#version 330 core
#extension ARB_geometry_shader4 : enable

//https://www.khronos.org/opengl/wiki/Built-in_Variable_(GLSL)
//https://www.khronos.org/opengl/wiki/Geometry_Shader
layout (TRIANGLES) in;
layout (TRIANGLE_STRIP, max_vertices = 48) out;

in vec4 gColors[];
out vec4 fColors; 

uniform mat4 VP;

int i = 0, x = 0, y = 0;
vec4 pos = vec4(0.0F, 0.0F, 0.0F, 0.0F), p1 = gl_in[0].gl_Position, p2 = gl_in[1].gl_Position, p3 = gl_in[2].gl_Position;

void main() {
	fColors = gColors[0];

	for (; i < 16; ++i) {
		pos.x = 3.0F * x;
		pos.y = 3.0F * y;

		if (x == 3) {
			y++;
			x = 0;
		} else {
			x++;
		}

		gl_Position = pos * VP + p1;
		EmitVertex();
		gl_Position = pos * VP + p2;
		EmitVertex();
		gl_Position = pos * VP + p3;
		EmitVertex();
		EndPrimitive();
	}
}